﻿// --------------------------------------------------------------------------
// Project Frocessing
// ActionScript 3.0 drawing library like Processing.
// --------------------------------------------------------------------------
//
// Frocessing drawing library
// Copyright (C) 2008-09  TAKANAWA Tomoaki (http://nutsu.com) and
//					   	  Spark project (www.libspark.org)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// contact : face(at)nutsu.com
//

package frocessing.f3d.materials 
{
	import frocessing.core.GraphicsEx3D;
	import frocessing.f3d.F3DModel;
	import flash.display.BitmapData;
	
	/**
	* 3D Material BitmapData Set
	* 
	* @author nutsu
	* @version 0.5
	*/
	public class F3DBmpSetMaterial extends F3DEmptySetMaterial
	{
		//BitmapData[]
		public var textures:Array;
		//BitmapData[]
		public var backTextures:Array;
		
		/**
		 * 
		 */
		public function F3DBmpSetMaterial( ...textures_ ) 
		{
			super();
			textures     = [];
			backTextures = [];
			for ( var i:int = 0; i < textures_.length ; i++ )
			{
				setTexture( i, textures_[i] );
			}
		}
		
		/**
		 * 
		 * @param	index
		 * @param	color
		 * @param	alpha
		 */
		public function setTexture( index:uint, texture_:BitmapData, backTexture_:BitmapData = null, visible_:Boolean = true, backface_:Boolean = false ):void
		{
			textures[index]     = texture_;
			backTextures[index] = backTexture_;
			visibles[index]     = visible_;
			backFaces[index]    = backface_;
		}
		
		/**
		 * draw model
		 * @param	g
		 */
		override public function draw( g:GraphicsEx3D, model:F3DModel ):void
		{
			if ( _visible )
			{
				var n:uint = model.faceSetNum;
				for ( var i:int = 0; i < n; i++ )
				{
					if ( Boolean(visibles[i]) )
					{
						g.backFaceCulling = !backFaces[i];
						g.beginTexture( textures[i], backTextures[i] );
						g.drawMesh( model.$vertices, model.faceSet[i], model.uvSet[i] );
						g.endTexture();
					}
				}
			}
		}
	}
	
}